/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPHeaderCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import external.AnimatedGifDemo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.autoplot.AppManager;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.GuiSupport;
import org.autoplot.JythonUtil;
import org.autoplot.ScriptContext2023;
import org.autoplot.Util;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.Plot;
import org.autoplot.pngwalk.ContextFlowView;
import org.autoplot.pngwalk.CoversWalkView;
import org.autoplot.pngwalk.GridPngWalkView;
import org.autoplot.pngwalk.HtmlOutputOptions;
import org.autoplot.pngwalk.ImageResize;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.QualityControlPanel;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.QualityControlSequence;
import org.autoplot.pngwalk.RichPngUtil;
import org.autoplot.pngwalk.RowPngWalkView;
import org.autoplot.pngwalk.SinglePngWalkView;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkImageSequence;
import org.autoplot.pngwalk.WalkUtil;
import org.autoplot.transferrable.ImageSelection;
import org.das2.components.DasProgressPanel;
import org.das2.components.DataPointRecorder;
import org.das2.components.TearoffTabbedPane;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.graph.Painter;
import org.das2.qds.QDataSet;
import org.das2.util.ArgumentList;
import org.das2.util.FileUtil;
import org.das2.util.ImageUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.xml.sax.SAXException;

public final class PngWalkTool
extends JPanel {
    private static boolean ENABLE_QUALITY_CONTROL;
    private QualityControlPanel qcPanel = null;
    public static final String PREF_RECENT = "pngWalkRecent";
    public static final String PREF_LAST_EXPORT = "pngWalkLastExport";
    private static final String DEFAULT_BOOKMARKS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><bookmark-list version=\"1.1\">    <bookmark-folder remoteUrl=\"http://autoplot.org/git/pngwalks.xml\"><title>Demos</title><bookmark-list>    <bookmark>        <title>POLAR/VIS Images</title>        <uri>pngwalk:http://vis.physics.uiowa.edu/survey/1996/04-apr/03/images/VIS_$Y_$m_$d_$H_$M_$S_EC.PNG</uri>        <description>Images from the POLAR/VIS instrument</description>    </bookmark>    <bookmark>        <title>RBSP Emfisis HFR-WFR Orbits</title>        <uri>pngwalk:https://emfisis.physics.uiowa.edu/pngwalk/RBSP-A/HFR-WFR_orbit/product_$(o,id=rbspa-pp).png</uri>    </bookmark>    <bookmark>        <title>RBSP-A MagEIS Combined Spectra</title>        <uri>pngwalk:https://www.rbsp-ect.lanl.gov/data_pub/rbspa/ect/level2/combined-elec/rbspa_ect_L2-elec_$Y$m$d_v.1.0.0.png</uri>    </bookmark></bookmark-list></bookmark-folder></bookmark-list>";
    public PngWalkView[] views;
    TearoffTabbedPane tabs;
    WalkImageSequence seq;
    JMenu navMenu;
    Pattern actionMatch = null;
    String actionCommand = null;
    static final Logger logger;
    private static final String RESOURCES = "/org/autoplot/resources/";
    private static final Icon WARNING_ICON;
    private static final Icon ERROR_ICON;
    private static final Icon BUSY_ICON;
    private static final Icon READY_ICON;
    private static final Icon IDLE_ICON;
    int returnTabIndex = 0;
    transient DatumRange pendingGoto = null;
    private String product;
    private String baseurl;
    private String version;
    private String qcturl;
    private String pwd = null;
    private String vapfile = null;
    private Window parentWindow;
    private List<AbstractButton> qcFilterMenuItems = new ArrayList<AbstractButton>();
    private transient PropertyChangeListener indexListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PngWalkTool.this.seq == null) {
                logger.fine("seq was null");
                return;
            }
            String item = DataSetURI.fromUri((URI)PngWalkTool.this.seq.currentImage().getUri());
            for (int i = 0; i < PngWalkTool.this.actionEnablers.size(); ++i) {
                if (PngWalkTool.this.actionEnablers.get(i) == null) continue;
                boolean actionEnabled = PngWalkTool.this.actionEnablers.get(i).isActionEnabled(item);
                PngWalkTool.this.actionButtons.get(i).setEnabled(actionEnabled);
                if (!actionEnabled) continue;
                PngWalkTool.this.actionButtons.get(i).setActionCommand(PngWalkTool.this.actionCommand + " " + item);
            }
            PngWalkTool.this.firePropertyChange(PngWalkTool.PROP_SELECTED_NAME, null, PngWalkTool.this.seq.getSelectedName());
            PngWalkTool.this.firePropertyChange(PngWalkTool.PROP_TIMERANGE, null, PngWalkTool.this.getTimeRange());
            if (PngWalkTool.this.qcPanel != null && PngWalkTool.this.seq.getQualityControlSequence() != null) {
                PngWalkTool.this.qcPanel.displayRecord(PngWalkTool.this.seq.getQualityControlSequence().getQualityControlRecord(PngWalkTool.this.seq.getIndex()));
            }
        }
    };
    private transient PropertyChangeListener statusListener = evt -> this.setStatus((String)evt.getNewValue());
    private final transient PropertyChangeListener qcStatusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PngWalkTool.this.seq == null) {
                logger.fine("seq was null");
                return;
            }
            if (PngWalkTool.this.seq.getQualityControlSequence() != null) {
                int[] n = PngWalkTool.this.seq.getQualityControlSequence().getQCTotals();
                PngWalkTool.this.qcPanel.setStatus(n[0], n[1], n[2], n[3]);
            }
        }
    };
    protected int thumbnailSize = 100;
    public static final String PROP_THUMBNAILSIZE = "thumbnailSize";
    transient DatumRange timeRange;
    public static final String PROP_TIMERANGE = "timeRange";
    private transient QDataSet mousePressLocation = null;
    public static final String PROP_MOUSEPRESSLOCATION = "mousePressLocation";
    private transient QDataSet mouseReleaseLocation = null;
    public static final String PROP_MOUSERELEASELOCATION = "mouseReleaseLocation";
    private MouseAdapter imageMouseAdapter = null;
    public static final String PROP_IMAGEMOUSEADAPTER = "imageMouseAdapter";
    transient PropertyChangeListener seqTimeRangeListener = evt -> this.setTimeRange((DatumRange)evt.getNewValue());
    boolean setting = false;
    transient PropertyChangeListener seqIndexListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean setting0 = PngWalkTool.this.setting;
            PngWalkTool.this.setting = true;
            DatumRange dr = PngWalkTool.this.seq.currentImage().getDatumRange();
            if (setting0 && dr != null) {
                PngWalkTool.this.setTimeRange(dr);
            }
            PngWalkTool.this.setting = false;
        }
    };
    protected transient String status = "initializing...";
    public static final String PROP_STATUS = "status";
    protected DataPointRecorder digitizer = null;
    protected boolean digitizerRecording = true;
    protected char annoTypeChar = (char)124;
    public static final ActionEnabler LOCAL_FILE_ENABLER;
    transient List<ActionEnabler> actionEnablers = new ArrayList<ActionEnabler>();
    List<JButton> actionButtons = new ArrayList<JButton>();
    List<Painter> decorators = new LinkedList<Painter>();
    public static final String PROP_SELECTED_NAME = "selectedName";
    private JPanel actionButtonsPanel;
    private JPanel bottomLeftPanel;
    private DataSetSelector dataSetSelector1;
    private JButton editRangeButton;
    private JPanel jPanel1;
    private JButton jumpToFirstButton;
    private JButton jumpToLastButton;
    private JPanel navigationPanel;
    private JButton nextButton;
    private JButton nextSetButton;
    private JPanel pngsPanel;
    private JButton prevButton;
    private JButton prevSetButton;
    private JCheckBox showMissingCheckBox;
    private JLabel statusLabel;
    private JTextField timeFilterTextField;
    private JCheckBox useRangeCheckBox;

    public static void main(String[] args) {
        DataSetURI.init();
        System.err.println("autoplot pngwalk 20141111");
        ArgumentList alm = new ArgumentList("PngWalkTool");
        alm.addOptionalSwitchArgument("nativeLAF", "n", "nativeLAF", "__true__", "use the system look and feel (T or F)");
        alm.addOptionalSwitchArgument("mode", "m", "mode", "filmStrip", "initial display mode: grid, filmStrip, covers, contextFlow, etc");
        alm.addOptionalSwitchArgument("goto", "g", "goto", "", "start display at the beginning of this range, e.g. 2010-01-01");
        alm.addBooleanSwitchArgument("qualityControl", "q", "qualityControl", "enable quality control review mode");
        String home = System.getProperty("user.home") + System.getProperty("file.separator");
        String output = "file:" + home + "pngwalk" + System.getProperty("file.separator") + "product_$Y$m$d.png";
        alm.addOptionalPositionArgument(0, "template", output, "initial template to use.");
        alm.addOptionalSwitchArgument("template", "t", "template", output, "initial template to use.");
        if (!alm.process(args)) {
            System.exit(alm.getExitCode());
        }
        if (alm.getBooleanValue("nativeLAF")) {
            logger.fine("nativeLAF");
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        ENABLE_QUALITY_CONTROL = alm.getBooleanValue("qualityControl");
        String template = alm.getValue("template");
        PngWalkTool pngWalkTool = PngWalkTool.start(template, null);
        pngWalkTool.processArguments(alm);
    }

    private static Map readPngwalkFile(String template) {
        URISplit split = URISplit.parse((String)template);
        InputStream in = null;
        String product = "";
        String baseurl = "";
        String pwd = "";
        String qcturl = "";
        String vapfile = "";
        String version = "";
        try {
            Properties p = new Properties();
            if (split.file == null) {
                throw new IllegalArgumentException("template does not appear to be files: " + template);
            }
            File local = DataSetURI.getFile((URI)split.resourceUri, (ProgressMonitor)new NullProgressMonitor());
            in = new FileInputStream(local);
            p.load(in);
            String vers = p.getProperty("version");
            vers = vers == null || vers.trim().length() == 0 ? "" : "_" + vers;
            pwd = split.path;
            product = p.getProperty("product");
            pwd = p.getProperty("pwd", pwd);
            baseurl = p.getProperty("baseurl", ".");
            if (!baseurl.startsWith(".")) {
                if (!baseurl.endsWith("/")) {
                    baseurl = baseurl + "/";
                }
                split.path = baseurl;
            } else {
                split.path = PngWalkTool.checkRelativeBaseurl(baseurl, pwd, product);
            }
            qcturl = p.getProperty("qcturl", "");
            String t = !p.getProperty("filePattern", "").equals("") ? split.path + p.getProperty("filePattern", "") : split.path + p.getProperty("product") + "_" + p.getProperty("timeFormat") + vers + ".png";
            template = t;
            vapfile = p.getProperty("vapfile", "");
            version = vers;
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException("File does not exist: " + template);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("template", template);
        result.put("product", product);
        result.put("baseurl", baseurl);
        result.put("qcturl", qcturl);
        result.put("pwd", pwd);
        result.put("vapfile", vapfile);
        result.put("version", version);
        return result;
    }

    private static void raiseApWindowSoon(Window apWindow) {
        Runnable run = () -> {
            GuiSupport.raiseApplicationWindow((JFrame)apWindow);
            apWindow.toFront();
            apWindow.repaint();
        };
        SwingUtilities.invokeLater(run);
    }

    private static String checkRelativeBaseurl(String baseurl, String template, String product) {
        if (baseurl.equals(".")) {
            URISplit split = URISplit.parse((String)template);
            String f = split.path;
            int i = f.indexOf("/" + product + ".pngwalk");
            if (i == -1 && (i = f.indexOf(42)) > -1) {
                i = f.lastIndexOf(47, i);
            }
            if (i == -1 && f.endsWith("/")) {
                baseurl = f;
            }
            if (i > -1) {
                baseurl = f.substring(0, i + 1);
            }
        } else if (baseurl.startsWith("../")) {
            URISplit split = URISplit.parse((String)template);
            String f = split.path;
            int i = f.lastIndexOf("/", f.length() - 2);
            if ((i = (f = f.substring(0, i) + baseurl.substring(2)).indexOf("/" + product + ".pngwalk")) == -1 && (i = f.indexOf(42)) > -1) {
                i = f.lastIndexOf(47, i);
            }
            if (i == -1 && f.endsWith("/")) {
                baseurl = f;
            }
            if (i > -1) {
                baseurl = f.substring(0, i + 1);
            }
        }
        return baseurl;
    }

    private void loadPngwalkFile(final String file) {
        boolean addToRecent;
        Map map = PngWalkTool.readPngwalkFile(file);
        this.product = (String)map.get("product");
        this.baseurl = (String)map.get("baseurl");
        this.qcturl = (String)map.get("qcturl");
        this.pwd = (String)map.get("pwd");
        this.vapfile = (String)map.get("vapfile");
        this.version = (String)map.get("version");
        this.baseurl = PngWalkTool.checkRelativeBaseurl(this.baseurl, file, this.product);
        boolean doStartQC = false;
        if (!"".equals(map.get("qcturl"))) {
            this.qcturl = PngWalkTool.checkRelativeBaseurl(this.qcturl, this.pwd, this.product);
            doStartQC = true;
        } else {
            this.qcturl = this.pwd;
        }
        this.vapfile = PngWalkTool.checkRelativeBaseurl(this.vapfile, this.pwd, this.product);
        String template = (String)map.get("template");
        this.setTemplate(template);
        if (doStartQC) {
            this.startQC();
        }
        if (addToRecent = true) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PngWalkTool.this.dataSetSelector1.addToRecent(file);
                }
            });
        }
    }

    public static PngWalkTool start(String template, Window parent) {
        PngWalkTool tool = new PngWalkTool();
        tool.parentWindow = parent;
        String sdeft = DEFAULT_BOOKMARKS;
        List<Bookmark> deft = null;
        try {
            deft = Bookmark.parseBookmarks(sdeft);
        }
        catch (IOException | BookmarksException | SAXException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        org.autoplot.bookmarks.Util.loadRecent("pngwalkRecent", tool.dataSetSelector1, deft);
        if (template != null) {
            URISplit split = URISplit.parse((String)template);
            if (split.file.endsWith(".pngwalk")) {
                tool.loadPngwalkFile(template);
            } else {
                tool.product = "";
                tool.baseurl = "";
                tool.pwd = split.path;
                tool.setTemplate(template);
            }
        } else {
            tool.product = "";
            tool.baseurl = "";
        }
        Runnable run = () -> PngWalkTool.addFileEnabler(tool, parent);
        new Thread(run).start();
        JFrame frame = new JFrame("PNG Walk Tool");
        frame.setIconImage(AutoplotUtil.getAutoplotIcon());
        frame.setJMenuBar(PngWalkTool.createMenuBar(tool, frame));
        AppManager.getInstance().addApplication(tool);
        frame.getContentPane().add(tool);
        frame.addWindowListener(AppManager.getInstance().getWindowListener(tool));
        frame.pack();
        frame.setLocationRelativeTo(parent);
        frame.setVisible(true);
        return tool;
    }

    private static void addFileEnabler(final PngWalkTool tool, final Window parent) {
        ActionEnabler enabler = filename -> {
            File file;
            String template = tool.getTemplate();
            int i0 = -1;
            if (i0 == -1) {
                i0 = template.indexOf("_$Y");
            }
            if (i0 == -1) {
                i0 = template.indexOf("_$o");
            }
            if (i0 == -1) {
                i0 = template.indexOf("_$(o,");
            }
            String productFile = null;
            if (i0 == -1) {
                try {
                    file = DataSetURI.getFile((String)filename, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
                    String json = ImageUtil.getJSONMetadata((File)file);
                    if (json != null) {
                        if (i0 == -1) {
                            i0 = template.indexOf(42);
                        }
                        if (i0 == -1) {
                            i0 = template.indexOf("$x");
                        }
                    }
                    productFile = tool.baseurl + tool.product + ".vap";
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
            try {
                file = DataSetURI.getFile((String)filename, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
                String scriptURI = ImageUtil.getScriptURI((File)file);
                if (scriptURI != null) {
                    return true;
                }
            }
            catch (FileSystem.FileSystemOfflineException ex) {
                Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (productFile == null && i0 > -1) {
                productFile = template.substring(0, i0) + ".vap";
            }
            try {
                String vv;
                if (productFile != null && !WalkUtil.fileExists(productFile) && template.startsWith(tool.baseurl) && (vv = tool.pwd + tool.product + ".vap") != null) {
                    if (WalkUtil.fileExists(vv)) {
                        return true;
                    }
                    if (tool.version != null && tool.version.length() > 0) {
                        vv = tool.pwd + tool.product + tool.version + ".vap";
                        return WalkUtil.fileExists(vv);
                    }
                    return false;
                }
                return WalkUtil.fileExists(productFile);
            }
            catch (URISyntaxException | FileSystem.FileSystemOfflineException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                return false;
            }
        };
        String lap = "View in Autoplot";
        tool.addFileAction(enabler, new AbstractAction("View in Autoplot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                String suri = null;
                if (tool.seq == null) {
                    suri = null;
                } else {
                    String timeRange;
                    int i0;
                    File file;
                    String s = tool.getSelectedFile();
                    String template = tool.getTemplate();
                    if (s.startsWith("file:/") && !s.startsWith("file:///") && template.startsWith("file:///")) {
                        s = "file:///" + s.substring(6);
                    }
                    DatumRange jsonTimeRange = null;
                    try {
                        file = DataSetURI.getFile((String)s, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
                        String json = ImageUtil.getJSONMetadata((File)file);
                        if (json != null) {
                            jsonTimeRange = RichPngUtil.getXRange(json);
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                    try {
                        file = DataSetURI.getFile((String)s, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
                        String scriptURI = ImageUtil.getScriptURI((File)file);
                        if (scriptURI != null) {
                            suri = scriptURI;
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                    int i = template.indexOf(36);
                    if (i != -1) {
                        int i2 = i + 1;
                        if (i2 == template.length()) {
                            throw new IllegalArgumentException("template must start with $Y, $y or $(o,...)");
                        }
                        char c = template.charAt(i2);
                        while (i2 < template.length() && (Character.isDigit(c) || c == '(')) {
                            c = template.charAt(++i2);
                        }
                        if (i2 == template.length() || c != 'Y' && c != 'y' && c != 'o' && c != 'x') {
                            throw new IllegalArgumentException("template must start with $Y, $y or $(o,...)");
                        }
                    }
                    if ((i0 = template.indexOf("_$Y")) == -1) {
                        i0 = template.indexOf("_$y");
                    }
                    if (i0 == -1) {
                        i0 = template.indexOf("_$o");
                    }
                    if (i0 == -1) {
                        i0 = template.indexOf("_$(o,");
                    }
                    if (i0 == -1 && jsonTimeRange != null) {
                        if (i0 == -1) {
                            i0 = template.indexOf("_*");
                        }
                        if (i0 == -1) {
                            i0 = template.indexOf("_$x");
                        }
                    }
                    if (s.contains("//user@") && !template.contains("//user@")) {
                        s = s.replace("//user@", "//");
                    }
                    if (jsonTimeRange == null || !UnitsUtil.isTimeLocation((Units)jsonTimeRange.getUnits())) {
                        TimeParser tp = TimeParser.create((String)template);
                        timeRange = s;
                        try {
                            DatumRange dr = tp.parse(timeRange).getTimeRange();
                            if (tp.getValidRange().equals((Object)dr)) {
                                timeRange = null;
                            }
                            timeRange = dr.toString().replaceAll(" ", "+");
                        }
                        catch (ParseException ex) {
                            throw new RuntimeException(ex);
                        }
                    } else {
                        timeRange = jsonTimeRange.toString().replaceAll("\\s", "+");
                    }
                    if (suri == null) {
                        String productFile = tool.product != null && tool.product.length() > 0 && tool.baseurl.length() > 1 ? tool.baseurl + tool.product + ".vap" : template.substring(0, i0) + ".vap";
                        try {
                            if (!WalkUtil.fileExists(productFile)) {
                                String productFile2 = tool.pwd + tool.product + ".vap";
                                if (WalkUtil.fileExists(productFile2)) {
                                    productFile = productFile2;
                                } else {
                                    productFile2 = tool.pwd + tool.product + tool.version + ".vap";
                                    if (WalkUtil.fileExists(productFile2)) {
                                        productFile = productFile2;
                                    }
                                }
                            }
                        }
                        catch (URISyntaxException | FileSystem.FileSystemOfflineException ex) {
                            logger.log(Level.SEVERE, null, ex);
                        }
                        if (timeRange != null) {
                            suri = productFile + "?timeRange=" + timeRange;
                        } else {
                            JOptionPane.showMessageDialog(parent, "unable to resolve time range from image metadata or filename.");
                            return;
                        }
                    }
                }
                String fsuri = suri;
                Runnable run = () -> {
                    ScriptContext2023 scriptContext;
                    Application dom;
                    AutoplotUI autoplot;
                    Window apWindow;
                    if (parent instanceof AutoplotUI) {
                        apWindow = parent;
                        autoplot = (AutoplotUI)apWindow;
                        dom = autoplot.getDom();
                        scriptContext = dom.getController().getScriptContext();
                    } else {
                        scriptContext = new ScriptContext2023();
                        scriptContext.createGui();
                        apWindow = scriptContext.getViewWindow();
                        autoplot = scriptContext.getApplication();
                        dom = autoplot.getDom();
                    }
                    if (fsuri != null) {
                        PngWalkTool.raiseApWindowSoon(apWindow);
                        if (fsuri.startsWith("script:")) {
                            autoplot.runScriptTools(fsuri);
                            return;
                        }
                        scriptContext.plot(fsuri);
                    }
                    for (int i = 0; i < dom.getPlots().length; ++i) {
                        Plot p = dom.getPlots(i);
                        if (p.getYaxis().isAutoRange()) {
                            AutoplotUtil.resetZoomY(dom, p);
                        }
                        if (!p.getZaxis().isAutoRange()) continue;
                        AutoplotUtil.resetZoomZ(dom, p);
                    }
                    if (parent == null) {
                        apWindow.setVisible(true);
                    }
                };
                new Thread(run).start();
            }
        });
    }

    protected static void copyToClipboard(Component parent, String ssrc) {
        File src;
        if (ssrc == null) {
            JOptionPane.showMessageDialog(parent, "No image is selected.");
            return;
        }
        try {
            src = FileSystemUtil.doDownload((String)ssrc, (ProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException | URISyntaxException ex) {
            JOptionPane.showMessageDialog(parent, "<html>Unexpected error when downloading file<br>" + ssrc + "<br><br>" + ex.toString());
            return;
        }
        try {
            ImageSelection iss = new ImageSelection();
            iss.setImage(ImageIO.read(src));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(iss, ImageSelection.getNullClipboardOwner());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(parent, "<html>Unable to read image<br>" + ex.getMessage());
        }
    }

    protected static void savePngwalkFile(PngWalkTool parent, String ssrc) throws IOException {
        Preferences prefs = AutoplotSettings.settings().getPreferences(PngWalkTool.class);
        String srecent = prefs.get(PREF_RECENT, System.getProperty("user.home"));
        JFileChooser chooser = new JFileChooser(srecent);
        chooser.setFileFilter(new FileNameExtensionFilter("pngwalk files", "pngwalk"));
        chooser.setMultiSelectionEnabled(false);
        if (0 == chooser.showSaveDialog(parent)) {
            File f = chooser.getSelectedFile();
            if (!f.getName().endsWith(".pngwalk")) {
                f = new File(f.getAbsolutePath() + ".pngwalk");
            }
            prefs.put(PREF_RECENT, f.getAbsolutePath());
            try (PrintWriter w = new PrintWriter(f);){
                if (parent.baseurl.length() == 0) {
                    String t = parent.getTemplate();
                    int i = WalkUtil.splitIndex(t);
                    w.println("baseurl=" + t.substring(0, i + 1));
                    String filePattern = t.substring(i + 1);
                    w.println("filePattern=" + filePattern);
                } else {
                    w.println("baseurl=" + parent.baseurl);
                    if (parent.product != null) {
                        w.println("product=" + parent.product);
                    }
                    String s = parent.getTemplate();
                    if (parent.product != null && s.endsWith(".png")) {
                        s = s.substring(0, s.length() - 4);
                    }
                    w.println("timeFormat=" + s);
                }
                String pwd = chooser.getSelectedFile().getParent();
                w.println("pwd=" + pwd);
                if (PngWalkTool.isQualityControlEnabled()) {
                    if (parent.getQCTUrl() != null) {
                        w.println("qcturl=" + parent.getQCTUrl());
                    } else {
                        w.println("qcturl=file://" + pwd);
                    }
                }
            }
            parent.setStatus(".pngwalk file saved: " + f);
        }
    }

    protected static void saveLocalCopy(Component parent, String ssrc) {
        File src;
        Preferences prefs = AutoplotSettings.settings().getPreferences(PngWalkTool.class);
        String srecent = prefs.get(PREF_RECENT, System.getProperty("user.home"));
        if (ssrc == null) {
            JOptionPane.showMessageDialog(parent, "No image is selected.");
            return;
        }
        try {
            src = FileSystemUtil.doDownload((String)ssrc, (ProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException | URISyntaxException ex) {
            JOptionPane.showMessageDialog(parent, "<html>Unexpected error when downloading file<br>" + ssrc + "<br><br>" + ex.toString());
            return;
        }
        JFileChooser chooser = new JFileChooser(srecent);
        JPanel accessoryPanel = new JPanel();
        accessoryPanel.setLayout(new BoxLayout(accessoryPanel, 1));
        JCheckBox r60 = new JCheckBox("Reduce to 60%");
        accessoryPanel.add(r60);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAccessory(accessoryPanel);
        chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), src.getName()));
        int r = chooser.showSaveDialog(parent);
        if (r == 0) {
            prefs.put(PREF_RECENT, chooser.getSelectedFile().getParent());
            try {
                if (!src.exists()) {
                    throw new IllegalArgumentException("Image file no longer exists: " + src);
                }
                if (r60.isSelected()) {
                    BufferedImage im = ImageIO.read(src);
                    int size = (int)Math.sqrt(im.getWidth() * im.getWidth() + im.getHeight() * im.getHeight());
                    im = ImageResize.getScaledInstance(im, size * 60 / 100);
                    String ext = chooser.getSelectedFile().toString();
                    int i = ext.lastIndexOf(46);
                    ext = ext.substring(i + 1);
                    ImageIO.write((RenderedImage)im, ext, chooser.getSelectedFile());
                } else if (!Util.copyFile(src, chooser.getSelectedFile())) {
                    JOptionPane.showMessageDialog(parent, "<html>Unable to save image to: <br>" + chooser.getSelectedFile());
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(parent, "<html>Unable to save image to: <br>" + chooser.getSelectedFile() + "<br><br>" + ex.toString());
            }
        }
    }

    int nextInterval(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getNextInterval(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getNextInterval(index);
            }
            return index + 7;
        }
        return index + 7;
    }

    int nextPage(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getNextPage(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getNextPage(index);
            }
            return index + 7;
        }
        return index + 28;
    }

    int prevInterval(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getPrevInterval(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getPrevInterval(index);
            }
            return index + 7;
        }
        return index - 7;
    }

    int prevPage(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getPrevPage(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getPrevPage(index);
            }
            return index + 7;
        }
        return index - 28;
    }

    private static JMenuBar createMenuBar(final PngWalkTool tool, final JFrame frame) {
        JMenuBar result = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new AbstractAction("Save Local Copy of Image..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                PngWalkTool.saveLocalCopy(tool, tool.getSelectedFile());
            }
        });
        fileMenu.add(new AbstractAction("Save .pngwalk File..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                try {
                    PngWalkTool.savePngwalkFile(tool, tool.getSelectedFile());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        fileMenu.add(new AbstractAction("Show Autoplot"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LoggerManager.logGuiEvent((ActionEvent)ae);
                AppManager appman = AppManager.getInstance();
                for (int i = 0; i < appman.getApplicationCount(); ++i) {
                    if (!(appman.getApplication(i) instanceof AutoplotUI)) continue;
                    AutoplotUI.raiseApplicationWindow((AutoplotUI)appman.getApplication(i));
                    return;
                }
                if (AppManager.getInstance().getApplicationCount() == 1) {
                    ScriptContext2023 scriptContext = new ScriptContext2023();
                    scriptContext.createGui();
                    Window apWindow = scriptContext.getViewWindow();
                    PngWalkTool.raiseApWindowSoon(apWindow);
                }
            }
        });
        fileMenu.add(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (AppManager.getInstance().getApplicationCount() == 1) {
                    if (0 == JOptionPane.showConfirmDialog(tool, "Quit application?", "Quit PNG Walk", 2) && AppManager.getInstance().closeApplication(tool)) {
                        frame.dispose();
                    }
                } else if (AppManager.getInstance().closeApplication(tool)) {
                    frame.dispose();
                }
            }
        });
        fileMenu.add(new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (AppManager.getInstance().requestQuit()) {
                    frame.dispose();
                    AppManager.getInstance().quit();
                }
            }
        });
        result.add(fileMenu);
        JMenu navMenu = new JMenu("Navigate");
        navMenu.add(new AbstractAction("Go To Date..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                DatumRange dr = tool.seq.getTimeSpan();
                if (dr == null) {
                    JOptionPane.showMessageDialog(tool, "File times are not available");
                    return;
                }
                String str = JOptionPane.showInputDialog(tool, "Select date to display", TimeDatumFormatter.DAYS.format(TimeUtil.prevMidnight((Datum)dr.min())));
                if (str != null) {
                    try {
                        DatumRange ds = DatumRangeUtil.parseTimeRange((String)str);
                        tool.seq.gotoSubrange(ds);
                    }
                    catch (ParseException ex) {
                        try {
                            double d = Units.us2000.parse(str).doubleValue((Units)Units.us2000);
                            tool.seq.gotoSubrange(DatumRange.newDatumRange((double)d, (double)d, (Units)Units.us2000));
                        }
                        catch (ParseException ex2) {
                            JOptionPane.showMessageDialog(tool, "parse error: " + ex2);
                        }
                    }
                    catch (RuntimeException ex) {
                        tool.setStatus("warning: " + ex.toString());
                    }
                }
            }
        });
        navMenu.add(new AbstractAction("First"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.setIndex(0);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(36, 0));
        navMenu.add(new AbstractAction("Previous Page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.setIndex(tool.prevPage(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(33, 0));
        navMenu.add(new AbstractAction("Previous Interval"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.setIndex(tool.prevInterval(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(38, 0));
        navMenu.add(new AbstractAction("Previous Item"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.skipBy(-1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(37, 0));
        navMenu.add(new AbstractAction("Next Item"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.skipBy(1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(39, 0));
        navMenu.add(new AbstractAction("Next Interval"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.setIndex(tool.nextInterval(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(40, 0));
        navMenu.add(new AbstractAction("Next Page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.setIndex(tool.nextPage(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(34, 0));
        navMenu.add(new AbstractAction("Last"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.seq.setIndex(tool.seq.size() - 1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(35, 0));
        result.add(navMenu);
        tool.navMenu = navMenu;
        navMenu.setEnabled(tool.seq != null);
        JMenu optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem persMi = new JCheckBoxMenuItem("Use Perspective", true);
        persMi.addActionListener(e -> ((CoversWalkView)tool.views[4]).setPerspective(persMi.isSelected()));
        optionsMenu.add(persMi);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        JMenu thumbsizeMenu = new JMenu("Thumbnail Size");
        int[] sizes = new int[]{50, 100, 200, 400};
        for (int i = 0; i < sizes.length; ++i) {
            final int fsize = sizes[i];
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(new AbstractAction("" + fsize + " px"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent((ActionEvent)e);
                    tool.setThumbnailSize(fsize);
                }
            });
            buttonGroup1.add(mi);
            if (tool.getThumbnailSize() == sizes[i]) {
                buttonGroup1.setSelected(mi.getModel(), true);
            }
            thumbsizeMenu.add(mi);
        }
        optionsMenu.add(thumbsizeMenu);
        JMenu qcFiltersMenu = new JMenu("QC Filters");
        ButtonGroup bg = new ButtonGroup();
        final JCheckBoxMenuItem qcmi = new JCheckBoxMenuItem("Show Only Quality Control Records", false);
        tool.qcFilterMenuItems.add(qcFiltersMenu);
        qcmi.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (qcmi.isSelected()) {
                    tool.seq.setQCFilter("op");
                }
            }
        });
        qcmi.setToolTipText("show only QC records with Okay or Problem setting.");
        tool.qcFilterMenuItems.add(qcmi);
        bg.add(qcmi);
        qcFiltersMenu.add(qcmi);
        final JCheckBoxMenuItem qcmi2 = new JCheckBoxMenuItem("Show Okay Records", false);
        qcmi2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (qcmi2.isSelected()) {
                    tool.seq.setQCFilter("o");
                }
            }
        });
        qcmi2.setToolTipText("show only QC records with Okay setting.");
        tool.qcFilterMenuItems.add(qcmi2);
        bg.add(qcmi2);
        qcFiltersMenu.add(qcmi2);
        final JCheckBoxMenuItem qcmi3 = new JCheckBoxMenuItem("Show Problem Records", false);
        qcmi3.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (qcmi3.isSelected()) {
                    tool.seq.setQCFilter("p");
                }
            }
        });
        qcmi3.setToolTipText("show only QC records with Problem setting.");
        tool.qcFilterMenuItems.add(qcmi3);
        bg.add(qcmi3);
        qcFiltersMenu.add(qcmi3);
        final JCheckBoxMenuItem qcmi5 = new JCheckBoxMenuItem("Don't show problem records", false);
        qcmi5.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (qcmi5.isSelected()) {
                    tool.seq.setQCFilter("uio");
                }
            }
        });
        qcmi5.setToolTipText("Don't show QC records with Problem setting.");
        tool.qcFilterMenuItems.add(qcmi5);
        bg.add(qcmi5);
        qcFiltersMenu.add(qcmi5);
        final JCheckBoxMenuItem qcmi4 = new JCheckBoxMenuItem("Show All Records", false);
        qcmi4.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (qcmi4.isSelected()) {
                    tool.seq.setQCFilter("");
                }
            }
        });
        qcmi4.setToolTipText("show all records.");
        tool.qcFilterMenuItems.add(qcmi4);
        bg.add(qcmi4);
        qcmi4.setSelected(true);
        qcFiltersMenu.add(qcmi4);
        optionsMenu.add(qcFiltersMenu);
        for (AbstractButton b : tool.qcFilterMenuItems) {
            b.setEnabled(tool.qcPanel != null);
        }
        result.add(optionsMenu);
        JMenu toolsMenu = new JMenu("Tools");
        JMenuItem qc = new JMenuItem(new AbstractAction("Start Quality Control Tool (QC)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (!PngWalkTool.isQualityControlEnabled()) {
                    tool.startQC();
                }
            }
        });
        qc.setToolTipText("Start up the Quality Control tool that adds documentation to images.");
        toolsMenu.add(qc);
        JMenuItem dg = new JMenuItem(new AbstractAction("Start Digitizer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                if (!tool.isDigitizerEnabled()) {
                    tool.startDigitizer();
                }
            }
        });
        dg.setToolTipText("Start up the Digitizer that receives pairs from the single view.  See http://autoplot.org/richPng.");
        toolsMenu.add(dg);
        toolsMenu.add(new JSeparator());
        JMenuItem writePdf = new JMenuItem(new AbstractAction("Write to PDF..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.writePdf();
            }
        });
        writePdf.setToolTipText("Write the visible images to a PDF file with last QC annotation.");
        toolsMenu.add(writePdf);
        result.add(toolsMenu);
        JMenuItem writeGif = new JMenuItem(new AbstractAction("Write to Animated GIF..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.writeAnimatedGif();
            }
        });
        writeGif.setToolTipText("Write the visible images to an animated GIF file.");
        toolsMenu.add(writeGif);
        JMenuItem writeHtml = new JMenuItem(new AbstractAction("Write to HTML..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.writeHtml();
            }
        });
        writeHtml.setToolTipText("Write the visible images to an HTML file.");
        toolsMenu.add(writeHtml);
        JMenuItem writeCsv = new JMenuItem(new AbstractAction("Write to CSV..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.writeCsv();
            }
        });
        writeCsv.setToolTipText("Write the visible images to a CSV file.");
        toolsMenu.add(writeCsv);
        result.add(toolsMenu);
        JMenuItem writeContactSheet = new JMenuItem(new AbstractAction("Write to PNG Contact Sheet..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                tool.writeContactSheet();
            }
        });
        writeContactSheet.setToolTipText("Write the visible thumbnails to PNG file.");
        toolsMenu.add(writeContactSheet);
        result.add(toolsMenu);
        JMenu bookmarksMenu = new JMenu("Bookmarks");
        BookmarksManager man = new BookmarksManager((Frame)frame, true, "PNG Bookmarks");
        man.getModel().addPropertyChangeListener("list", evt -> man.updateBookmarks(bookmarksMenu, tool.getSelector()));
        man.setVisible(false);
        man.setPrefNode("pngwalk", "autoplot.default.pngwalk.bookmarks", "http://autoplot.org/data/pngwalk.demos.xml");
        man.updateBookmarks(bookmarksMenu, tool.getSelector());
        result.add(bookmarksMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem helpContentsMI = new JMenuItem(new AbstractAction("Help Contents..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                String surl = "http://autoplot.org/PNGWalks";
                AutoplotUtil.openBrowser(surl);
            }
        });
        helpContentsMI.setToolTipText("Help page for the PNG Walk Tool.");
        helpMenu.add(helpContentsMI);
        result.add(helpMenu);
        return result;
    }

    public PngWalkTool() {
        this.initComponents();
        this.setNavButtonsEnabled(false);
        this.dataSetSelector1.setEnableDataSource(false);
        this.dataSetSelector1.setAcceptPattern("(?i).*(\\.gif|\\.png|\\.jpg|\\.pngwalk)");
        this.dataSetSelector1.setSuggestFiles(false);
        this.dataSetSelector1.addSuggestFile(".*\\.pngwalk");
        this.dataSetSelector1.registerActionTrigger(".*\\.pngwalk", (Action)new AbstractAction("pngwalk"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String template = PngWalkTool.this.dataSetSelector1.getValue();
                if (template.endsWith(".pngwalk")) {
                    PngWalkTool.this.loadPngwalkFile(template);
                } else {
                    PngWalkTool.this.setTemplate(template);
                }
            }
        });
        this.views = new PngWalkView[7];
        this.views[0] = new GridPngWalkView(null);
        this.views[1] = new RowPngWalkView(null);
        this.views[2] = new SinglePngWalkView(null, this);
        this.views[3] = new SinglePngWalkView(null, this);
        this.views[4] = new CoversWalkView(null);
        this.views[5] = new SinglePngWalkView(null, this);
        this.views[6] = new ContextFlowView(null);
        int SCROLLBAR_HEIGHT = (int)Math.round(new JScrollPane().getHorizontalScrollBar().getPreferredSize().getHeight());
        JSplitPane filmStripSplitPane = new JSplitPane(0, this.views[1], this.views[2]);
        filmStripSplitPane.setDividerLocation(this.getThumbnailSize() + (int)(1.2 * (double)SCROLLBAR_HEIGHT));
        this.views[1].addPropertyChangeListener(PROP_THUMBNAILSIZE, evt -> filmStripSplitPane.setDividerLocation((Integer)evt.getNewValue() + SCROLLBAR_HEIGHT));
        filmStripSplitPane.setMinimumSize(new Dimension(640, 480));
        filmStripSplitPane.setPreferredSize(new Dimension(640, 480));
        JSplitPane coversSplitPane = new JSplitPane(0, this.views[4], this.views[5]);
        coversSplitPane.setDividerLocation(this.getThumbnailSize() + (int)(1.2 * (double)SCROLLBAR_HEIGHT));
        this.views[4].addPropertyChangeListener(PROP_THUMBNAILSIZE, evt -> coversSplitPane.setDividerLocation((Integer)evt.getNewValue() + SCROLLBAR_HEIGHT));
        coversSplitPane.setMinimumSize(new Dimension(640, 480));
        coversSplitPane.setPreferredSize(new Dimension(640, 480));
        this.tabs = new TearoffTabbedPane();
        this.tabs.addTab("Single", (Component)new JScrollPane(this.views[3]));
        this.tabs.addTab("ContextFlow", (Component)this.views[6]);
        this.tabs.addTab("Grid", (Component)this.views[0]);
        this.tabs.addTab("Film Strip", (Component)filmStripSplitPane);
        this.tabs.addTab("Covers", (Component)coversSplitPane);
        this.tabs.setSelectedIndex(3);
        for (PngWalkView view : this.views) {
            view.getMouseTarget().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && PngWalkTool.this.digitizer == null) {
                        int oldIndex = PngWalkTool.this.tabs.getSelectedIndex();
                        if (oldIndex == 0) {
                            PngWalkTool.this.tabs.setSelectedIndex(PngWalkTool.this.returnTabIndex);
                        } else {
                            PngWalkTool.this.tabs.setSelectedIndex(0);
                            PngWalkTool.this.returnTabIndex = oldIndex;
                        }
                    }
                }
            });
        }
        this.tabs.setFocusable(false);
        this.nextButton.requestFocus();
        if (PngWalkTool.isQualityControlEnabled()) {
            this.qcPanel = new QualityControlPanel(this);
            JSplitPane qcPane = new JSplitPane(1, true, (Component)this.tabs, this.qcPanel);
            qcPane.setResizeWeight(1.0);
            this.pngsPanel.add(qcPane);
            this.qcPanel.setWalkImageSequence(this.seq);
        } else {
            this.pngsPanel.add((Component)this.tabs);
        }
        this.pngsPanel.revalidate();
        BindingGroup bc = new BindingGroup();
        for (PngWalkView view : this.views) {
            AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)view, (Property)BeanProperty.create((String)PROP_THUMBNAILSIZE), (Object)this, (Property)BeanProperty.create((String)PROP_THUMBNAILSIZE));
            bc.addBinding((Binding)b);
        }
        bc.bind();
        this.addMouseWheelListener(e -> {
            if (this.seq != null && this.seq.size() != 0) {
                this.seq.skipBy(e.getWheelRotation());
            }
        });
        this.setStatus("ready");
    }

    private void processArguments(ArgumentList alm) {
        String tab = alm.getValue("mode");
        if (tab.equalsIgnoreCase("filmStrip")) {
            this.tabs.setSelectedIndex(3);
        } else if (tab.equalsIgnoreCase("single")) {
            this.tabs.setSelectedIndex(0);
        } else if (tab.equalsIgnoreCase("contextFlow")) {
            this.tabs.setSelectedIndex(1);
        } else if (tab.equalsIgnoreCase("grid")) {
            this.tabs.setSelectedIndex(2);
        } else if (tab.equalsIgnoreCase("film strip")) {
            this.tabs.setSelectedIndex(3);
        } else if (tab.equalsIgnoreCase("covers")) {
            this.tabs.setSelectedIndex(4);
        }
        String show = alm.getValue("goto");
        if (!show.equals("") && this.seq != null) {
            try {
                if (this.seq.getTimeSpan() != null) {
                    this.seq.gotoSubrange(DatumRangeUtil.parseTimeRange((String)show));
                }
                this.pendingGoto = DatumRangeUtil.parseTimeRange((String)show);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            logger.fine("show was empty or seq was null");
        }
    }

    private void setNavButtonsEnabled(boolean enabled) {
        this.jumpToFirstButton.setEnabled(enabled);
        this.jumpToLastButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.nextSetButton.setEnabled(enabled);
        this.prevSetButton.setEnabled(enabled);
    }

    public void setTemplate(String template) {
        if (template.contains("%") && !template.contains("$") && (template = template.replaceAll("\\%", "\\$")).contains("{") && !template.contains("(")) {
            template = template.replaceAll("\\{", "(");
            template = template.replaceAll("\\}", ")");
        }
        URISplit split = URISplit.parse((String)template);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        this.dataSetSelector1.setValue(template);
        WalkImageSequence oldseq = this.seq;
        URI uri = DataSetURI.getResourceURI((String)template);
        if (uri == null) {
            throw new IllegalArgumentException("Unable to parse: " + template);
        }
        String surl = DataSetURI.fromUri((URI)uri);
        try {
            this.seq = new WalkImageSequence(surl);
            String tr = (String)params.get("timerange");
            if (tr != null) {
                try {
                    DatumRange trdr = DatumRangeUtil.parseTimeRange((String)tr);
                    this.seq.setTimerange(trdr);
                }
                catch (ParseException ex) {
                    this.setMessage(ERROR_ICON, "unable to parse timerange");
                }
            }
            this.setNavButtonsEnabled(true);
            if (this.navMenu != null) {
                this.navMenu.setEnabled(true);
            }
            this.seq.setQCFilter("");
            if (this.qcFilterMenuItems != null) {
                for (AbstractButton b : this.qcFilterMenuItems) {
                    b.setEnabled(this.qcPanel != null);
                }
            }
            if (this.qcPanel != null) {
                this.qcPanel.setWalkImageSequence(this.seq);
            }
        }
        catch (Exception ex) {
            this.seq = null;
            this.setNavButtonsEnabled(false);
            if (this.navMenu != null) {
                this.navMenu.setEnabled(false);
            }
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        if (oldseq != null) {
            oldseq.removePropertyChangeListener("index", this.indexListener);
            oldseq.removePropertyChangeListener(PROP_STATUS, this.statusListener);
            if (ENABLE_QUALITY_CONTROL) {
                oldseq.removePropertyChangeListener("badgeChange", this.qcStatusListener);
            }
            oldseq.removePropertyChangeListener(PROP_TIMERANGE, this.seqTimeRangeListener);
            oldseq.removePropertyChangeListener("index", this.seqIndexListener);
        }
        if (this.seq != null) {
            this.seq.addPropertyChangeListener("index", this.indexListener);
            this.seq.addPropertyChangeListener(PROP_STATUS, this.statusListener);
            if (ENABLE_QUALITY_CONTROL) {
                this.seq.addPropertyChangeListener("badgeChange", this.qcStatusListener);
            }
            this.seq.addPropertyChangeListener(PROP_TIMERANGE, this.seqTimeRangeListener);
            this.seq.addPropertyChangeListener("index", this.seqIndexListener);
        }
        if (template.length() == 0) {
            this.setStatus("Enter the location of a pngwalk file by providing a template for the files, such as /tmp/$Y$m$d.png");
            return;
        }
        Runnable run = () -> {
            try {
                this.seq.initialLoad();
                if (this.pendingGoto != null) {
                    this.seq.gotoSubrange(this.pendingGoto);
                    this.pendingGoto = null;
                }
            }
            catch (IOException e) {
                Container p;
                if (!this.getStatus().startsWith("error")) {
                    this.setStatus("error:" + e.getMessage());
                }
                if ((p = SwingUtilities.getWindowAncestor(this)) == null) {
                    p = this.parentWindow;
                }
                if (this.getX() != 0) {
                    p = this;
                }
                JOptionPane.showMessageDialog(p, "<html>Unable to find directory for: <br>" + this.seq.getTemplate());
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PngWalkTool.this.updateInitialGui();
                }
            });
        };
        new Thread(run).start();
    }

    private void updateInitialGui() {
        this.dataSetSelector1.addToRecent(this.seq.getTemplate());
        this.useRangeCheckBox.setEnabled(this.seq.getTimeSpan() != null);
        this.useRangeCheckBox.setSelected(false);
        this.editRangeButton.setEnabled(false);
        this.timeFilterTextField.setEnabled(false);
        this.timeFilterTextField.setText("");
        if (this.seq.size() == 0) {
            Container p = SwingUtilities.getWindowAncestor(this);
            if (p == null) {
                p = this.parentWindow;
            }
            if (this.getX() != 0) {
                p = this;
            }
            JOptionPane.showMessageDialog(p, "<html>Unable to find any images in sequence:<br>" + this.seq.getTemplate());
            return;
        }
        DatumRange tr = this.seq.currentImage().getDatumRange();
        if (tr != null) {
            this.setTimeRange(tr);
        }
        this.showMissingCheckBox.setEnabled(this.seq.getTimeSpan() != null);
        if (this.seq.getTimeSpan() == null) {
            this.showMissingCheckBox.setEnabled(false);
            this.showMissingCheckBox.setSelected(false);
        } else {
            this.seq.setShowMissing(this.showMissingCheckBox.isSelected());
        }
        for (PngWalkView v : this.views) {
            v.setSequence(this.seq);
        }
        if (this.seq.size() == 0) {
            this.setStatus("warning: no files found in " + this.seq.getTemplate());
        } else {
            this.indexListener.propertyChange(null);
            if (this.qcPanel != null) {
                this.qcPanel.setWalkImageSequence(this.seq);
                if (this.seq.getIndex() < this.seq.size()) {
                    if (this.seq.getQualityControlSequence() != null) {
                        QualityControlRecord rec = this.seq.getQualityControlSequence().getQualityControlRecord(this.seq.getIndex());
                        this.qcPanel.displayRecord(rec);
                        int[] n = this.seq.getQualityControlSequence().getQCTotals();
                        this.qcPanel.setStatus(n[0], n[1], n[2], n[3]);
                    }
                } else {
                    this.qcPanel.setStatus(0, 0, 0, 0);
                }
            }
        }
    }

    public String getTemplate() {
        return this.seq.getTemplate();
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getQCTUrl() {
        return this.qcturl;
    }

    public int getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setThumbnailSize(int thumbnailSize) {
        int oldThumbnailSize = this.thumbnailSize;
        this.thumbnailSize = thumbnailSize;
        this.firePropertyChange(PROP_THUMBNAILSIZE, oldThumbnailSize, thumbnailSize);
    }

    public DatumRange getTimeRange() {
        try {
            DatumRange tr = this.seq.imageAt(this.seq.getIndex()).getDatumRange();
            if (tr != null) {
                return tr;
            }
            return this.timeRange;
        }
        catch (Exception ex) {
            return this.timeRange;
        }
    }

    public void setTimeRange(DatumRange timeRange) {
        boolean setting0 = this.setting;
        this.setting = true;
        DatumRange old = this.timeRange;
        this.timeRange = timeRange;
        if (this.seq != null && timeRange != null) {
            this.seq.gotoSubrange(timeRange);
        }
        if (setting0) {
            this.firePropertyChange(PROP_TIMERANGE, old, timeRange);
        }
        this.setting = false;
    }

    public QDataSet getMousePressLocation() {
        return this.mousePressLocation;
    }

    public void setMousePressLocation(QDataSet mousePressLocation) {
        QDataSet oldMousePressLocation = this.mousePressLocation;
        this.mousePressLocation = mousePressLocation;
        this.firePropertyChange(PROP_MOUSEPRESSLOCATION, oldMousePressLocation, mousePressLocation);
    }

    public QDataSet getMouseReleaseLocation() {
        return this.mouseReleaseLocation;
    }

    public void setMouseReleaseLocation(QDataSet mouseReleaseLocation) {
        QDataSet oldMouseReleaseLocation = this.mouseReleaseLocation;
        this.mouseReleaseLocation = mouseReleaseLocation;
        this.firePropertyChange(PROP_MOUSERELEASELOCATION, oldMouseReleaseLocation, mouseReleaseLocation);
    }

    public MouseAdapter getImageMouseAdapter() {
        return this.imageMouseAdapter;
    }

    public void setImageMouseAdapter(MouseAdapter imageMouseAdapter) {
        MouseAdapter oldImageMouseAdapter = this.imageMouseAdapter;
        this.imageMouseAdapter = imageMouseAdapter;
        this.firePropertyChange(PROP_IMAGEMOUSEADAPTER, oldImageMouseAdapter, imageMouseAdapter);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String message) {
        String oldStatus = this.status;
        this.status = message;
        if (message.startsWith("busy:")) {
            this.setMessage(BUSY_ICON, message.substring(5).trim());
            logger.finer(message);
        } else if (message.startsWith("warning:")) {
            this.setMessage(WARNING_ICON, message.substring(8).trim());
            logger.warning(message);
        } else if (message.startsWith("error:")) {
            this.setMessage(ERROR_ICON, message.substring(6).trim());
            logger.severe(message);
        } else {
            logger.fine(message);
            this.setMessage(message);
        }
        this.firePropertyChange(PROP_STATUS, oldStatus, message);
    }

    public void setMessage(String message) {
        this.setMessage(IDLE_ICON, message);
    }

    public void setMessage(Icon icon, String message) {
        String myMess;
        if (message == null) {
            message = "<null>";
        }
        if ((myMess = message).length() > 100) {
            myMess = myMess.substring(0, 100) + "...";
        }
        String fMyMessag = myMess;
        String fMessage = message;
        Runnable run = () -> {
            this.statusLabel.setIcon(icon);
            this.statusLabel.setText(fMyMessag);
            this.statusLabel.setToolTipText(fMessage);
        };
        SwingUtilities.invokeLater(run);
    }

    public void startQC() {
        if (!PngWalkTool.isQualityControlEnabled()) {
            this.qcPanel = new QualityControlPanel(this);
            this.tabs.add("Quality Control", (Component)this.qcPanel);
            if (this.seq != null) {
                this.qcPanel.setWalkImageSequence(this.seq);
                this.seq.addPropertyChangeListener("badgeChange", this.qcStatusListener);
            }
            ENABLE_QUALITY_CONTROL = true;
        }
        for (AbstractButton b : this.qcFilterMenuItems) {
            b.setEnabled(true);
        }
    }

    public void startDigitizer() {
        if (this.digitizer == null) {
            this.digitizer = new DataPointRecorder();
            this.digitizer.addDataSetUpdateListener(e -> {
                for (PngWalkView v : this.views) {
                    if (!(v instanceof SinglePngWalkView)) continue;
                    v.repaint();
                }
            });
            this.digitizer.addDataPointSelectionListener(e -> {
                String image = e.getPlane("image").toString();
                int i = this.seq.findIndex(image);
                if (i > -1) {
                    this.seq.setIndex(i);
                }
            });
            this.tabs.add("Digitizer", (Component)this.digitizer);
            for (PngWalkView v : this.views) {
                if (!(v instanceof SinglePngWalkView)) continue;
                ((SinglePngWalkView)v).clickDigitizer.setViewer(this);
            }
            JComboBox<String> annoType = new JComboBox<String>(new String[]{"| vertical line", "+ cross hairs", ". dots"});
            this.digitizer.addAccessory(annoType);
            annoType.addItemListener(e -> {
                this.annoTypeChar = e.getItem().toString().charAt(0);
                for (PngWalkView v : this.views) {
                    if (!(v instanceof SinglePngWalkView)) continue;
                    v.repaint();
                }
            });
            this.digitizerRecording = true;
        }
    }

    private boolean isDigitizerEnabled() {
        return this.digitizer != null;
    }

    public DataPointRecorder getDigitizerDataPointRecorder() {
        return this.digitizer;
    }

    public void setDigitizerRecording(boolean enable) {
        this.digitizerRecording = enable;
    }

    private void writeContactSheet() {
        Component ttt = this.tabs.getTabByTitle("Grid");
        if (ttt instanceof GridPngWalkView) {
            try {
                Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
                String fname = prefs.get("writeToContactSheet", "/tmp/contactSheet.png");
                JFileChooser chooser = new JFileChooser(fname);
                if (!fname.equals("/tmp/contactSheet.png")) {
                    chooser.setSelectedFile(new File(fname));
                }
                chooser.setFileFilter(new FileNameExtensionFilter("PNG Files", "png"));
                if (chooser.showSaveDialog(this) == 0) {
                    File f = chooser.getSelectedFile();
                    if (!f.getName().endsWith(".png")) {
                        f = new File(f.getParentFile(), f.getName() + ".png");
                    }
                    this.writeContactSheet(f);
                    prefs.put("writeToContactSheet", f.toString());
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this.parentWindow, "Error while creating contact sheet");
            }
        }
    }

    public void writeContactSheet(File f) throws IOException {
        Component ttt = this.tabs.getTabByTitle("Grid");
        if (ttt instanceof GridPngWalkView) {
            BufferedImage im = ((GridPngWalkView)ttt).paintContactSheet();
            ImageIO.write((RenderedImage)im, "png", f);
            this.setMessage("Wrote to " + f);
        }
    }

    public void addFileAction(ActionEnabler match, Action abstractAction) {
        this.actionEnablers.add(match);
        JButton b = new JButton(abstractAction);
        this.actionButtons.add(b);
        this.actionButtonsPanel.add(b);
        this.revalidate();
    }

    public void addActionComponent(JComponent c, PropertyChangeListener p) {
        if (c != null) {
            this.actionButtonsPanel.add(c);
        }
        if (p != null) {
            this.addPropertyChangeListener(PROP_SELECTED_NAME, p);
            this.addPropertyChangeListener(PROP_TIMERANGE, p);
            this.addPropertyChangeListener(PROP_MOUSEPRESSLOCATION, p);
            this.addPropertyChangeListener(PROP_MOUSERELEASELOCATION, p);
        }
        this.revalidate();
    }

    public void removeActionComponent(JComponent c, PropertyChangeListener p) {
        if (c != null) {
            this.actionButtonsPanel.remove(c);
        }
        if (p != null) {
            this.removePropertyChangeListener(PROP_SELECTED_NAME, p);
            this.removePropertyChangeListener(PROP_TIMERANGE, p);
            this.removePropertyChangeListener(PROP_MOUSEPRESSLOCATION, p);
            this.removePropertyChangeListener(PROP_MOUSERELEASELOCATION, p);
        }
        this.revalidate();
    }

    public void addTopDecorator(Painter p) {
        if (!this.decorators.contains(p)) {
            this.decorators.add(p);
        }
        this.repaint();
    }

    public void removeTopDecorator(Painter p) {
        this.decorators.remove(p);
        this.repaint();
    }

    public void removeTopDecorators() {
        this.decorators.clear();
        this.repaint();
    }

    public boolean hasTopDecorators() {
        return !this.decorators.isEmpty();
    }

    public void setBottomLeftPanel(JComponent c) {
        this.bottomLeftPanel.removeAll();
        if (c != null) {
            this.bottomLeftPanel.add((Component)c, "Center");
        }
        this.revalidate();
    }

    public void clearBottomLeftPanel() {
        this.bottomLeftPanel.removeAll();
    }

    public JPanel getNavigationPanel() {
        return this.navigationPanel;
    }

    public String getSelectedFile() {
        if (this.seq == null) {
            return null;
        }
        if (this.seq.size() == 0) {
            return null;
        }
        return DataSetURI.fromUri((URI)this.seq.currentImage().getUri());
    }

    public String getSelectedName() {
        if (this.seq.size() > 0) {
            return this.seq.getSelectedName();
        }
        return "";
    }

    public void setSelectedName(String name) {
        String oldName = this.getSelectedName();
        int i = this.seq.findIndex(name);
        if (i != -1) {
            this.seq.setIndex(i);
        }
        this.firePropertyChange(PROP_SELECTED_NAME, oldName, name);
    }

    public BufferedImage getSelectedImage() {
        return this.seq.currentImage().getImage();
    }

    DataSetSelector getSelector() {
        return this.dataSetSelector1;
    }

    public static boolean isQualityControlEnabled() {
        return ENABLE_QUALITY_CONTROL;
    }

    public void setQCStatus(String text, QualityControlRecord.Status status) {
        if (this.qcPanel == null) {
            throw new IllegalArgumentException("QC Panel must be started");
        }
        this.qcPanel.setStatus(text, status);
        this.repaint();
    }

    private void initComponents() {
        this.pngsPanel = new JPanel();
        this.actionButtonsPanel = new JPanel();
        this.dataSetSelector1 = new DataSetSelector();
        this.statusLabel = new JLabel();
        this.bottomLeftPanel = new JPanel();
        this.navigationPanel = new JPanel();
        this.timeFilterTextField = new JTextField();
        this.showMissingCheckBox = new JCheckBox();
        this.useRangeCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.prevSetButton = new JButton();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.nextSetButton = new JButton();
        this.jumpToFirstButton = new JButton();
        this.jumpToLastButton = new JButton();
        this.editRangeButton = new JButton();
        this.pngsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pngsPanel.setLayout(new BorderLayout());
        this.actionButtonsPanel.setLayout(new FlowLayout(2));
        this.dataSetSelector1.setToolTipText("Enter the location of the images as a wildcard (/tmp/*.png) or template (/tmp/$Y$m$d.png).  .png, .gif, and .jpg files are supported.");
        this.dataSetSelector1.setPromptText("Enter images filename template");
        this.dataSetSelector1.setValue("");
        this.dataSetSelector1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.dataSetSelector1ActionPerformed(evt);
            }
        });
        this.statusLabel.setText("starting application...");
        this.bottomLeftPanel.setLayout(new BorderLayout());
        this.timeFilterTextField.setToolTipText("Enter a time range, for example a year like \"2009\", or month \"2009 may\", or \"2009-01-01 to 2009-03-10\"\n");
        this.timeFilterTextField.setEnabled(false);
        this.timeFilterTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PngWalkTool.this.timeFilterTextFieldFocusLost(evt);
            }
        });
        this.timeFilterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.timeFilterTextFieldActionPerformed(evt);
            }
        });
        this.showMissingCheckBox.setText("Show Missing");
        this.showMissingCheckBox.setToolTipText("Insert placeholder images where there are gaps detected in the sequence");
        this.showMissingCheckBox.setEnabled(false);
        this.showMissingCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PngWalkTool.this.showMissingCheckBoxItemStateChanged(evt);
            }
        });
        this.showMissingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.showMissingCheckBoxActionPerformed(evt);
            }
        });
        this.useRangeCheckBox.setText("Limit range to:");
        this.useRangeCheckBox.setToolTipText("Limit the time range of the images in the sequence.");
        this.useRangeCheckBox.setEnabled(false);
        this.useRangeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PngWalkTool.this.useRangeCheckBoxItemStateChanged(evt);
            }
        });
        this.prevSetButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrevPrev.png")));
        this.prevSetButton.setToolTipText("Skip to previous interval");
        this.prevSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.prevSetButtonActionPerformed(evt);
            }
        });
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrev.png")));
        this.prevButton.setToolTipText("previous");
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.prevButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNext.png")));
        this.nextButton.setToolTipText("next");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.nextButtonActionPerformed(evt);
            }
        });
        this.nextSetButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNextNext.png")));
        this.nextSetButton.setToolTipText("Skip to next interval");
        this.nextSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.nextSetButtonActionPerformed(evt);
            }
        });
        this.jumpToFirstButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrevPrevStop.png")));
        this.jumpToFirstButton.setToolTipText("jump to first");
        this.jumpToFirstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.jumpToFirstButtonActionPerformed(evt);
            }
        });
        this.jumpToLastButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNextNextStop.png")));
        this.jumpToLastButton.setToolTipText("jump to last");
        this.jumpToLastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.jumpToLastButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(112, Short.MAX_VALUE).add((Component)this.jumpToFirstButton).addPreferredGap(0).add((Component)this.prevSetButton).addPreferredGap(0).add((Component)this.prevButton).add(39, 39, 39).add((Component)this.nextButton).addPreferredGap(0).add((Component)this.nextSetButton).addPreferredGap(0).add((Component)this.jumpToLastButton)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.prevButton).add((Component)this.prevSetButton).add((Component)this.jumpToFirstButton).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.nextButton).add((Component)this.nextSetButton).add((Component)this.jumpToLastButton)));
        jPanel1Layout.linkSize(new Component[]{this.nextButton, this.nextSetButton, this.prevButton, this.prevSetButton}, 2);
        this.editRangeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/resources/calendar.png")));
        this.editRangeButton.setToolTipText("Time Range Tool");
        this.editRangeButton.setEnabled(false);
        this.editRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.editRangeButtonActionPerformed(evt);
            }
        });
        GroupLayout navigationPanelLayout = new GroupLayout((Container)this.navigationPanel);
        this.navigationPanel.setLayout((LayoutManager)navigationPanelLayout);
        navigationPanelLayout.setHorizontalGroup((GroupLayout.Group)navigationPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)navigationPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)navigationPanelLayout.createParallelGroup(1).add((GroupLayout.Group)navigationPanelLayout.createSequentialGroup().add(18, 18, 18).add((Component)this.useRangeCheckBox).addPreferredGap(0).add((Component)this.timeFilterTextField, -2, 236, -2).add(12, 12, 12).add((Component)this.editRangeButton).add(18, 18, 18).add((Component)this.showMissingCheckBox)).add((Component)this.jPanel1, -2, -1, -2)).addContainerGap()));
        navigationPanelLayout.setVerticalGroup((GroupLayout.Group)navigationPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)navigationPanelLayout.createSequentialGroup().add((GroupLayout.Group)navigationPanelLayout.createParallelGroup(3).add((Component)this.timeFilterTextField, -2, -1, -2).add((Component)this.useRangeCheckBox).add((Component)this.editRangeButton).add((Component)this.showMissingCheckBox)).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)));
        this.bottomLeftPanel.add((Component)this.navigationPanel, "Center");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.pngsPanel, -1, 932, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.dataSetSelector1, -1, -1, Short.MAX_VALUE).add((Component)this.statusLabel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bottomLeftPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.actionButtonsPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pngsPanel, -1, 639, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.dataSetSelector1, -2, 27, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.bottomLeftPanel, -1, -1, Short.MAX_VALUE).add((Component)this.actionButtonsPanel, -2, 57, -2)).addPreferredGap(0).add((Component)this.statusLabel)));
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.seq.skipBy(1);
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.seq.skipBy(-1);
    }

    private void nextSetButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.seq.setIndex(this.nextInterval(this.seq.getIndex()));
    }

    private void prevSetButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.seq.setIndex(this.prevInterval(this.seq.getIndex()));
    }

    private void timeFilterTextFieldActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.updateTimeRangeFilter();
    }

    public void updateTimeRangeFilter() {
        try {
            this.timeFilterTextField.setBackground(this.dataSetSelector1.getBackground());
            DatumRange range = DatumRangeUtil.parseTimeRange((String)this.timeFilterTextField.getText());
            this.seq.setActiveSubrange(range);
        }
        catch (ParseException ex) {
            this.timeFilterTextField.setBackground(Color.PINK);
        }
    }

    private void timeFilterTextFieldFocusLost(FocusEvent evt) {
    }

    private void jumpToLastButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.seq.last();
    }

    private void jumpToFirstButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        this.seq.first();
    }

    private void dataSetSelector1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        String t = this.dataSetSelector1.getValue();
        if (t.endsWith(".pngwalk")) {
            this.loadPngwalkFile(t);
        } else {
            this.setTemplate(t);
        }
        this.nextButton.requestFocus();
    }

    private void showMissingCheckBoxItemStateChanged(ItemEvent evt) {
        this.seq.setShowMissing(evt.getStateChange() == 1);
    }

    private void editRangeButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent((ActionEvent)evt);
        TimeRangeTool t = new TimeRangeTool();
        if (this.seq.isUseSubRange()) {
            t.setSelectedRange(this.timeFilterTextField.getText());
        } else {
            List<DatumRange> times = this.seq.getAllTimes();
            DatumRange tr = times.get(0);
            for (DatumRange tr1 : times) {
                tr = tr.union(tr1);
            }
            t.setSelectedRange(this.timeFilterTextField.getText());
        }
        if (0 == JOptionPane.showConfirmDialog(this.parentWindow, t, "Subrange", 2)) {
            try {
                DatumRange range = DatumRangeUtil.parseDatumRange((String)t.getSelectedRange());
                this.timeFilterTextField.setText(range.toString());
                this.updateTimeRangeFilter();
            }
            catch (ParseException ex) {
                Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void useRangeCheckBoxItemStateChanged(ItemEvent evt) {
        boolean enable = evt.getStateChange() == 1;
        this.seq.setUseSubRange(enable);
        this.timeFilterTextField.setEnabled(enable);
        this.editRangeButton.setEnabled(enable);
        if (!enable) {
            return;
        }
        List<DatumRange> current = this.seq.getActiveSubrange();
        DatumRange range = DatumRangeUtil.union((DatumRange)current.get(0), (DatumRange)current.get(current.size() - 1));
        this.timeFilterTextField.setText(range.toString());
    }

    private void showMissingCheckBoxActionPerformed(ActionEvent evt) {
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TearoffTabbedPane getTabs() {
        return this.tabs;
    }

    public WalkImageSequence getSequence() {
        return this.seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHtmlImmediately(ProgressMonitor monitor, File f, String summary) throws FileNotFoundException {
        URI base;
        block24: {
            monitor.setTaskSize((long)this.seq.size());
            monitor.started();
            if (this.seq.getQCFolder() != null) {
                base = this.seq.getQCFolder();
            } else {
                int splitIndex = -1;
                if (splitIndex == -1) {
                    splitIndex = WalkUtil.splitIndex(this.seq.getTemplate());
                }
                try {
                    base = new URI(this.seq.getTemplate().substring(0, splitIndex));
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (!f.exists() && !f.mkdirs()) {
                logger.log(Level.WARNING, "unable to create folder: {0}", f);
            }
            boolean writeInSitu = base.relativize(f.toURI()).toString().trim().length() == 0;
            try {
                if (writeInSitu) break block24;
                for (int i = 0; i < this.seq.size(); ++i) {
                    monitor.setTaskProgress((long)i);
                    if (monitor.isCancelled()) {
                        break;
                    }
                    BufferedImage im = this.seq.imageAt(i).getImage();
                    while (im == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        im = this.seq.imageAt(i).getImage();
                    }
                    try {
                        String n = base.relativize(this.seq.imageAt(i).getUri()).getPath();
                        ImageIO.write((RenderedImage)im, "png", new File(f, n));
                        File qcFile = new File(this.seq.imageAt(i).getUri().getPath() + ".ok");
                        if (qcFile.exists()) {
                            FileUtil.fileCopy((File)qcFile, (File)new File(f, n + ".ok"));
                        }
                        if (!(qcFile = new File(this.seq.imageAt(i).getUri().getPath() + ".problem")).exists()) continue;
                        FileUtil.fileCopy((File)qcFile, (File)new File(f, n + ".problem"));
                        continue;
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
            finally {
                monitor.finished();
            }
        }
        try {
            URL url = new URL("https://github.com/autoplot/scripts/makeTutorialHtml.jy");
            File nf = DataSetURI.getFile((URL)url, (ProgressMonitor)new NullProgressMonitor());
            DasProgressPanel mon = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this), (String)"write HTML");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dir", base.toString() + "/");
            params.put("qconly", this.seq.getQCFilter().equals("") ? "F" : "T");
            String sd = f.toString();
            if (!sd.endsWith("/") && !sd.endsWith("\\")) {
                sd = sd + "/";
            }
            params.put("outdir", sd);
            params.put("name", "");
            params.put("summary", summary);
            try {
                Application dom = null;
                if (this.parentWindow instanceof AutoplotUI) {
                    AutoplotUI parent = (AutoplotUI)this.parentWindow;
                    dom = parent.getDom();
                }
                JythonUtil.invokeScriptSoon(nf.toURI(), dom, params, false, false, (ProgressMonitor)mon);
            }
            catch (IOException ex) {
                Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeHtml() {
        JFileChooser choose = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
        String fname = prefs.get("writeToHtml", "/tmp/pngwalk/");
        choose.setFileSelectionMode(1);
        choose.setSelectedFile(new File(fname));
        HtmlOutputOptions hoo = new HtmlOutputOptions();
        choose.setAccessory(hoo);
        if (choose.showSaveDialog(this) == 0) {
            File f = choose.getSelectedFile();
            prefs.put("writeToHtml", f.toString());
            DasProgressPanel mon = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this), (String)"write html");
            Runnable run = () -> this.lambda$writeHtml$16((ProgressMonitor)mon, f, hoo);
            new Thread(run).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToPdfImmediately(ProgressMonitor monitor, File f) throws FileNotFoundException {
        try {
            monitor.setTaskSize((long)this.seq.size());
            monitor.started();
            int imageNumber = 1;
            FileOutputStream out = new FileOutputStream(f);
            Rectangle rect = new Rectangle(612.0f, 792.0f);
            Document doc = new Document(rect, 0.0f, 0.0f, 0.0f, 0.0f);
            doc.addCreator("autoplotPngwalkTool");
            doc.addCreationDate();
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            doc.open();
            QualityControlSequence qcseq = this.seq.getQualityControlSequence();
            Font lightGreyFont = new Font();
            lightGreyFont.setColor(BaseColor.LIGHT_GRAY);
            Chunk lineChunk = new Chunk("_________________________________________________________________", lightGreyFont);
            logger.log(Level.FINE, "writeToPdf {0} {1} pages", new Object[]{f.getName(), this.seq.size()});
            for (int i = 0; i < this.seq.size(); ++i) {
                monitor.setTaskProgress((long)i);
                if (monitor.isCancelled()) break;
                PdfContentByte cb = writer.getDirectContent();
                cb.saveState();
                BufferedImage im = this.seq.imageAt(i).getImage();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    QualityControlRecord r;
                    while (im == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        im = this.seq.imageAt(i).getImage();
                    }
                    logger.log(Level.FINER, "Page {0} of {1} image {2}x{3}", new Object[]{imageNumber, this.seq.size(), im.getHeight(), im.getWidth()});
                    ImageIO.write((RenderedImage)im, "png", baos);
                    Image pdfImage = Image.getInstance((byte[])baos.toByteArray());
                    int w = 540;
                    int h = w * im.getHeight() / im.getWidth();
                    pdfImage.setAbsolutePosition(36.0f, (float)(756 - h));
                    pdfImage.scaleToFit((float)w, (float)h);
                    PdfPTable table = new PdfPTable(1);
                    table.getDefaultCell().setBorder(0);
                    table.getDefaultCell().setPaddingLeft(48.0f);
                    table.getDefaultCell().setPaddingRight(24.0f);
                    table.setWidthPercentage(100.0f);
                    PdfPHeaderCell cell = new PdfPHeaderCell();
                    cell.setFixedHeight(72.0f);
                    cell.setPaddingLeft(48.0f);
                    cell.setPaddingRight(24.0f);
                    cell.setHorizontalAlignment(2);
                    cell.setVerticalAlignment(6);
                    Paragraph p = new Paragraph();
                    p.setAlignment(2);
                    p.add(String.format("%d of %d", imageNumber, this.seq.size()));
                    cell.addElement((Element)p);
                    cell.setBorder(0);
                    cell.setPaddingLeft(48.0f);
                    cell.setPaddingRight(48.0f);
                    table.addCell((PdfPCell)cell);
                    cell = new PdfPCell(pdfImage);
                    cell.setBorder(0);
                    cell.setPaddingLeft(48.0f);
                    cell.setPaddingRight(24.0f);
                    table.addCell((PdfPCell)cell);
                    String caption = qcseq != null ? ((r = qcseq.getQualityControlRecord(i)) != null ? r.getLastComment() : "") : "";
                    logger.log(Level.FINER, "caption: {0}", caption);
                    p = new Paragraph();
                    p.add(caption);
                    cell = new PdfPCell((Phrase)p);
                    cell.setBorder(0);
                    cell.setPaddingLeft(48.0f);
                    cell.setPaddingRight(48.0f);
                    table.addCell((PdfPCell)cell);
                    cell = new PdfPCell((Phrase)p);
                    cell.addElement((Element)new Paragraph(" "));
                    for (int j = 0; j < 10; ++j) {
                        p = new Paragraph(lineChunk);
                        cell.addElement((Element)p);
                    }
                    cell.setBorder(0);
                    cell.setPaddingLeft(48.0f);
                    cell.setPaddingRight(48.0f);
                    table.addCell((PdfPCell)cell);
                    Chunk nameChunk = new Chunk(this.seq.imageAt((int)i).uriString, lightGreyFont);
                    cell = new PdfPCell((Phrase)new Paragraph(nameChunk));
                    cell.setBorder(0);
                    cell.setPaddingLeft(48.0f);
                    cell.setPaddingRight(48.0f);
                    table.addCell((PdfPCell)cell);
                    doc.add((Element)table);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                cb.restoreState();
                doc.newPage();
                ++imageNumber;
            }
            doc.close();
        }
        catch (DocumentException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            monitor.finished();
        }
    }

    public void writePdf() {
        JFileChooser choose = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
        String fname = prefs.get("writeToPdf", "/tmp/pngwalk.pdf");
        choose.setSelectedFile(new File(fname));
        choose.setFileFilter(new FileNameExtensionFilter("pdf files", "pdf"));
        if (choose.showSaveDialog(this) == 0) {
            File f = choose.getSelectedFile();
            prefs.put("writeToPdf", f.toString());
            DasProgressPanel mon = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this), (String)"write pdf");
            Runnable run = () -> this.lambda$writePdf$17((ProgressMonitor)mon, f);
            new Thread(run).start();
        }
    }

    public void writeCsv() {
        JFileChooser choose = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
        String fname = prefs.get("writeToCsv", "/tmp/pngwalk.csv");
        choose.setFileSelectionMode(0);
        choose.setSelectedFile(new File(fname));
        choose.setFileFilter(new FileNameExtensionFilter("csv files", "csv"));
        if (choose.showSaveDialog(this) == 0) {
            File f = choose.getSelectedFile();
            prefs.put("writeToCsv", f.toString());
            DasProgressPanel mon = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this), (String)"write csv");
            Runnable run = () -> this.lambda$writeCsv$18((ProgressMonitor)mon, f);
            new Thread(run).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCsvImmediately(ProgressMonitor monitor, File f) throws FileNotFoundException {
        try (PrintWriter pout = new PrintWriter(f);){
            monitor.setTaskSize((long)this.seq.size());
            monitor.started();
            QualityControlSequence qcseq = this.seq.getQualityControlSequence();
            logger.log(Level.FINE, "writeToCsv {1}", new Object[]{f.getName()});
            pout.println("start,stop,label,filename,lastQCMessage,QCStatus");
            for (int i = 0; i < this.seq.size(); ++i) {
                String status;
                String lastComment;
                String filename;
                monitor.setTaskProgress((long)i);
                if (monitor.isCancelled()) {
                    break;
                }
                WalkImage wi = this.seq.imageAt(i);
                String s = wi.getUri().toString();
                URI rel = this.seq.getBaseUri().relativize(wi.getUri());
                DatumRange dr = wi.getDatumRange();
                String smin = dr == null ? "" : dr.min().toString();
                String smax = dr == null ? "" : dr.max().toString();
                String scaption = wi.getCaption();
                if (scaption.contains(" ") || scaption.contains(",")) {
                    scaption = "\"" + scaption + "\"";
                }
                if ((filename = rel.toString()).contains(" ") || filename.contains(",")) {
                    filename = "\"" + filename + "\"";
                }
                QualityControlRecord qcr = qcseq == null ? null : qcseq.getQualityControlRecord(i);
                String string = lastComment = qcr == null ? "" : qcr.getLastComment();
                if (lastComment.trim().length() > 0) {
                    int nl = lastComment.indexOf("\n");
                    if (nl > -1) {
                        lastComment = lastComment.substring(0, nl);
                    }
                    lastComment = "\"" + lastComment + "\"";
                }
                String string2 = status = qcr == null ? "" : qcr.getStatus().toString();
                if (status.equals("Unknown")) {
                    status = "";
                }
                String line = String.format("%s,%s,%s,%s,%s,%s", smin, smax, scaption, filename, lastComment, status);
                pout.println(line);
            }
        }
        finally {
            monitor.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToAnimatedGifImmediately(final ProgressMonitor monitor, File f, final String overrideDelays, final boolean r60) throws FileNotFoundException {
        try {
            Datum baset;
            monitor.setTaskSize((long)this.seq.size());
            monitor.started();
            DatumRange baseRange = this.seq.imageAt(0).getDatumRange();
            if (baseRange != null) {
                baset = this.seq.imageAt(0).getDatumRange().min();
            } else {
                if (overrideDelays != null && !overrideDelays.endsWith("ms")) {
                    throw new IllegalArgumentException("template does not imply timeranges");
                }
                baset = null;
            }
            Iterator images = new Iterator(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < PngWalkTool.this.seq.size() && !monitor.isCancelled();
                }

                public Object next() {
                    BufferedImage im = PngWalkTool.this.seq.imageAt(this.i).getImage();
                    monitor.setTaskProgress((long)this.i);
                    while (im == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        im = PngWalkTool.this.seq.imageAt(this.i).getImage();
                    }
                    if (r60) {
                        int size = (int)Math.sqrt(im.getWidth() * im.getWidth() + im.getHeight() * im.getHeight());
                        im = ImageResize.getScaledInstance(im, size * 60 / 100);
                    }
                    ++this.i;
                    return im;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove is not supported");
                }
            };
            Iterator delays = new Iterator(){
                int i = 0;
                Datum lastTime;

                @Override
                public boolean hasNext() {
                    throw new IllegalArgumentException("use images.next");
                }

                public String next() {
                    String result;
                    if (this.i == 0) {
                        this.lastTime = baset;
                    }
                    ++this.i;
                    if (this.i == PngWalkTool.this.seq.size()) {
                        --this.i;
                    }
                    if (overrideDelays != null) {
                        switch (overrideDelays) {
                            case "realTime": {
                                result = String.valueOf((int)Math.ceil(PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min().subtract(this.lastTime).convertTo(Units.milliseconds).value() / 10.0));
                                this.lastTime = PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min();
                                break;
                            }
                            case "secondPerDay": {
                                result = String.valueOf((int)Math.ceil(PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min().subtract(this.lastTime).convertTo(Units.milliseconds).value() / 864000.0));
                                this.lastTime = PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min();
                                break;
                            }
                            default: {
                                try {
                                    result = String.valueOf((int)Math.ceil(Units.milliseconds.parse(overrideDelays).value() / 10.0));
                                    break;
                                }
                                catch (ParseException ex) {
                                    throw new IllegalArgumentException(ex);
                                }
                            }
                        }
                    } else {
                        result = "1";
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove is not supported");
                }
            };
            logger.log(Level.FINE, "writing to {0}", f);
            AnimatedGifDemo.saveAnimate(f, images, delays);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            monitor.finished();
        }
    }

    public void writeAnimatedGif() {
        JFileChooser choose = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
        String fname = prefs.get("writeToGif", "/tmp/pngwalk.gif");
        choose.setSelectedFile(new File(fname));
        String[] opts = new String[]{"10ms", "50ms", "200ms", "400ms", "800ms", "1000ms", "1200ms", "realTime", "secondPerDay"};
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JComboBox<String> jo = new JComboBox<String>(opts);
        jo.setSelectedIndex(1);
        jo.setMaximumSize(new Dimension(1000, 30));
        jo.setEditable(true);
        p.add(new JLabel("Interslide-Delay:"));
        p.add(jo);
        JCheckBox r60 = new JCheckBox("Reduce to 60%");
        p.add(r60);
        p.add(Box.createGlue());
        choose.setAccessory(p);
        if (choose.showSaveDialog(this) == 0) {
            File f = choose.getSelectedFile();
            prefs.put("writeToGif", f.toString());
            DasProgressPanel mon = DasProgressPanel.createFramed((Window)SwingUtilities.getWindowAncestor(this), (String)"write animated gif");
            String fdelay = (String)jo.getSelectedItem();
            Runnable run = () -> this.lambda$writeAnimatedGif$19((ProgressMonitor)mon, f, fdelay, r60);
            new Thread(run).start();
        }
    }

    private /* synthetic */ void lambda$writeAnimatedGif$19(ProgressMonitor mon, final File f, String fdelay, JCheckBox r60) {
        try {
            this.writeToAnimatedGifImmediately(mon, f, fdelay, r60.isSelected());
            File outf = new File(f.getParentFile(), "pngwalk.mp4");
            String cmd = "ffmpeg -i " + f.toString() + " -y -movflags faststart -pix_fmt yuv420p -vf \"scale=trunc(iw/2)*2:trunc(ih/2)*2\" " + outf.toString();
            System.err.println("Convert to mp4 on Linux:");
            System.err.println(cmd);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel("wrote file " + f));
            JButton b = new JButton("Open in Browser");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoplotUtil.openBrowser(f.toURI().toString());
                }
            });
            panel.add(b);
            JButton b2 = new JButton("Copy filename to clipboard");
            b2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiSupport.setClipboard(f.toURI().toString());
                }
            });
            panel.add(b2);
            JOptionPane.showMessageDialog(this, panel);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private /* synthetic */ void lambda$writeCsv$18(ProgressMonitor mon, final File f) {
        try {
            this.writeToCsvImmediately(mon, f);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel("wrote file " + f));
        JButton b = new JButton("Open in Browser");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoplotUtil.openBrowser(f.toURI().toString());
            }
        });
        panel.add(b);
        JButton b2 = new JButton("Copy filename to clipboard");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiSupport.setClipboard(f.toURI().toString());
            }
        });
        panel.add(b2);
        JOptionPane.showMessageDialog(this, panel);
    }

    private /* synthetic */ void lambda$writePdf$17(ProgressMonitor mon, final File f) {
        try {
            this.writeToPdfImmediately(mon, f);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel("wrote file " + f));
            JButton b = new JButton("Open in Browser");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoplotUtil.openBrowser(f.toURI().toString());
                }
            });
            panel.add(b);
            JButton b2 = new JButton("Copy filename to clipboard");
            b2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiSupport.setClipboard(f.toURI().toString());
                }
            });
            panel.add(b2);
            JOptionPane.showMessageDialog(this, panel);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private /* synthetic */ void lambda$writeHtml$16(ProgressMonitor mon, File f, HtmlOutputOptions hoo) {
        try {
            this.writeToHtmlImmediately(mon, f, hoo.getTitle());
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        logger = LoggerManager.getLogger((String)"autoplot.pngwalk");
        WARNING_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/warning-icon.png"));
        ERROR_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/error-icon.png"));
        BUSY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/spinner.gif"));
        READY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/indProgress0.png"));
        IDLE_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/idle-icon.png"));
        LOCAL_FILE_ENABLER = filename -> DataSetURI.getResourceURI((String)filename).toString().startsWith("file:");
    }

    public static interface ActionEnabler {
        public boolean isActionEnabled(String var1);
    }
}

